@extends('layouts.admin')

@section('content')
    <!-- Page Header -->
    <div class="py-6 bg-[#F6F6F6] border-b border-[#CBB4B0]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Detail Karyawan</h1>
                    <p class="text-gray-600 mt-1">{{ $employee->name }}</p>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.employees.index') }}" 
                       class="bg-[#8B8B8B] text-white px-4 py-2 rounded-none hover:bg-[#192D50] transition duration-150">
                        Kembali
                    </a>
                    <a href="{{ route('admin.employees.edit', $employee) }}" 
                       class="bg-[#192D50] text-white px-4 py-2 rounded-none hover:bg-[#8B8B8B] transition duration-150">
                        Edit
                    </a>
                    <a href="{{ route('admin.companies.show', $employee->company) }}" 
                       class="bg-[#192D50] text-white px-4 py-2 rounded-none hover:bg-[#8B8B8B] transition duration-150">
                        Lihat Perusahaan
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 bg-[#F6F6F6]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Stats Cards -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Status</p>
                                <p class="text-2xl font-semibold text-gray-900">
                                    <span class="{{ $employee->is_active ? 'text-[#8B8B8B]' : 'text-[#CBB4B0]' }}">
                                        {{ $employee->is_active ? 'Aktif' : 'Tidak Aktif' }}
                                    </span>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#8B8B8B] rounded-full flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Perusahaan</p>
                                <p class="text-lg font-semibold text-gray-900">{{ $employee->company->name }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Nomor Karyawan</p>
                                <p class="text-lg font-semibold text-gray-900 font-mono">{{ $employee->employee_number }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#8B8B8B] rounded-full flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Kode Akses</p>
                                <p class="text-lg font-semibold text-gray-900 font-mono">{{ $employee->access_code }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                <!-- Employee Information -->
                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Karyawan</h3>
                        
                        <dl class="space-y-4">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Nama Lengkap</dt>
                                <dd class="text-sm text-gray-900">{{ $employee->name }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Email</dt>
                                <dd class="text-sm text-gray-900">{{ $employee->email }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Telepon</dt>
                                <dd class="text-sm text-gray-900">{{ $employee->phone }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Tanggal Lahir</dt>
                                <dd class="text-sm text-gray-900">{{ $employee->birth_date->format('d F Y') }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Tempat Lahir</dt>
                                <dd class="text-sm text-gray-900">{{ $employee->birth_place }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Jenis Kelamin</dt>
                                <dd class="text-sm text-gray-900">{{ ucfirst($employee->gender) }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Alamat</dt>
                                <dd class="text-sm text-gray-900">{{ $employee->address }}</dd>
                            </div>
                        </dl>
                    </div>
                </div>

                <!-- Work Information -->
                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Pekerjaan</h3>
                        
                        <dl class="space-y-4">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Perusahaan</dt>
                                <dd class="text-sm text-gray-900">{{ $employee->company->name }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Kode Perusahaan</dt>
                                <dd class="text-sm text-gray-900 font-mono">{{ $employee->company->company_code }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Posisi</dt>
                                <dd class="text-sm text-gray-900">{{ $employee->position }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Departemen</dt>
                                <dd class="text-sm text-gray-900">{{ $employee->department }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Nomor Karyawan</dt>
                                <dd class="text-sm text-gray-900 font-mono">{{ $employee->employee_number }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Status</dt>
                                <dd class="text-sm text-gray-900">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                        @if($employee->is_active) bg-[#8B8B8B] text-white
                                        @else bg-[#192D50] text-white @endif">
                                        {{ $employee->is_active ? 'Aktif' : 'Tidak Aktif' }}
                                    </span>
                                </dd>
                            </div>
                        </dl>
                    </div>
                </div>
            </div>

            <!-- Access Codes -->
            <div class="mt-8 bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                <div class="p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-medium text-gray-900">Kode Akses</h3>
                        <form method="POST" action="{{ route('admin.employees.generate-access-code', $employee) }}" class="inline">
                            @csrf
                            <button type="submit" 
                                    class="bg-[#192D50] text-white px-4 py-2 rounded-none text-sm font-medium hover:bg-[#8B8B8B] transition duration-150">
                                Generate Kode Baru
                            </button>
                        </form>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-[#F6F6F6] p-4 rounded-none border border-[#CBB4B0]">
                            <h4 class="font-medium text-gray-900 mb-2">Nomor Karyawan</h4>
                            <p class="text-2xl font-mono font-bold text-gray-900">{{ $employee->employee_number }}</p>
                            <p class="text-sm text-gray-500 mt-1">Digunakan untuk identifikasi karyawan</p>
                        </div>
                        
                        <div class="bg-[#F6F6F6] p-4 rounded-none border border-[#CBB4B0]">
                            <h4 class="font-medium text-gray-900 mb-2">Kode Akses</h4>
                            <p class="text-2xl font-mono font-bold text-gray-900">{{ $employee->access_code }}</p>
                            <p class="text-sm text-gray-500 mt-1">Digunakan untuk login ke sistem MCU</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Company Information -->
            <div class="mt-8 bg-white overflow-hidden shadow-sm sm:rounded-none">
                <div class="p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-medium text-gray-900">Informasi Perusahaan</h3>
                        <a href="{{ route('admin.companies.show', $employee->company) }}" 
                           class="bg-[#192D50] text-white px-4 py-2 rounded-none text-sm font-medium hover:bg-[#8B8B8B] transition duration-150">
                            Lihat Detail
                        </a>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <h4 class="font-medium text-gray-900 mb-2">Nama Perusahaan</h4>
                            <p class="text-sm text-gray-900">{{ $employee->company->name }}</p>
                        </div>
                        
                        <div>
                            <h4 class="font-medium text-gray-900 mb-2">Kode Perusahaan</h4>
                            <p class="text-sm text-gray-900 font-mono">{{ $employee->company->company_code }}</p>
                        </div>
                        
                        <div>
                            <h4 class="font-medium text-gray-900 mb-2">Email Perusahaan</h4>
                            <p class="text-sm text-gray-900">{{ $employee->company->email }}</p>
                        </div>
                        
                        <div>
                            <h4 class="font-medium text-gray-900 mb-2">Telepon Perusahaan</h4>
                            <p class="text-sm text-gray-900">{{ $employee->company->phone }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
